#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// lost CityMod01.fsh  by   jorge2017a1
//https://www.shadertoy.com/view/slSSz3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1-
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
// start Common //
///------------------------------------
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)


///--------------------------------------------FIN
///--------------------------------------------
vec3 hsv(vec3 c)
{
    vec4 k=vec4(1.,2./3.,1./3.,3.);
    vec3 p=abs(fract(c.xxx+k.xyz)*6.-k.www);
    return c.z*mix(k.xxx,clamp(p-k.xxx,0.,1.),c.y);
}

///Gracias a SHane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    return mat3(tx*tx, ty*ty, tz*tz)*n; 
}


vec3  Arrcolores[] = vec3[] (
vec3(0,0,0)/255.0,  //0
vec3(255.,255.,255.)/255.0, //1
vec3(255,0,0)/255.0,  //2
vec3(0,255,0)/255.0,   //3
vec3(0,0,255)/255.0,   //4
vec3(255,255,0)/255.0,  //5
vec3(0,255,255)/255.0,  //6 
vec3(255,0,255)/255.0,   //7
vec3(192,192,192)/255.0,  //8
vec3(128,128,128)/255.0,  //9
vec3(128,0,0)/255.0,   //10
vec3(128,128,0)/255.0,  //11
vec3(0,128,0)/255.0,   //12
vec3(128,0,128)/255.0,  //13
vec3(0,128,128)/255.0,  //14
vec3(0,0,128)/255.0,    //15
vec3(255, 204, 188)/255.0,  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(247./255., 168./255.,  184./255.),  //21
vec3(0, 1, 1),                           //22 
vec3(85./255., 205./255., 252./255.),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1), //30
vec3(.395, .95, 1.), //31
vec3(0.425, 0.56, 0.9) 
);

//----------------------------------------------------
vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}
///--------------------------------------------
// end Common  //
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )



float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}
float unionSDF(float distA, float distB)
	{ return min(distA, distB);}
float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
//----------oPeraciones de Repeticion
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}

///------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{   float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------
vec2 rotatev2(vec2 p, float ang)
{   float c = cos(ang);
    float s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}


float sdLink( vec3 p, float le, float r1, float r2 )
{
  vec3 q = vec3( p.x, max(abs(p.y)-le,0.0), p.z );
  return length(vec2(length(q.xy)-r1,q.z)) - r2;
}


vec3 ColumnaCaidaI(vec3 p)
{
    vec3 res= vec3(9999.0, -1.0,-1.0);  
     p= rotate_x( p, radians(45.0));
   
   vec3 p1a=p-vec3(0.0,2.0,0.0);
   vec3 p1b=p-vec3(5.0,2.0,0.0);
   p1a=rotate_z(p1a, radians(10.0));
   p1b=rotate_z(p1b, radians(350.0));
   
   float sdb1a= sdBox( p1a, vec3(3.0,10.0,5.0) );
   float sdb1b= sdBox( p1b, vec3(3.0,10.0,5.0) );
   res =opU3(res, vec3(sdb1a,5.0,MATERIAL_NO));
   res =opU3(res, vec3(sdb1b,5.0,MATERIAL_NO));
   
   float sdcy1=sdCylinderXZ( p-vec3(2.5,17.0,0.0), vec2(2.5,5.0) );
   res =opU3(res, vec3(sdcy1,1.0,MATERIAL_NO));
   return res;    
}

vec3 ColumnaCaidaII(vec3 p)
{
    vec3 res= vec3(9999.0, -1.0,-1.0);
    p= rotate_x( p, radians(45.0));
   vec3 p1a=p-vec3(0.0,3.0,0.0);
   vec3 p1b=p-vec3(5.0,3.0,0.0);
   p1a=rotate_z(p1a, radians(10.0));
   p1b=rotate_z(p1b, radians(350.0));
   
   float sdb1a= sdBox( p1a, vec3(3.0,10.0,10.0) );
   float sdb1b= sdBox( p1b, vec3(3.0,10.0,10.0) );
   res =opU3(res, vec3(sdb1a,2.0,MATERIAL_NO));
   res =opU3(res, vec3(sdb1b,2.0,MATERIAL_NO));
   
   float sdcy1=sdCylinderXZ( p-vec3(2.5,17.0, 3.0), vec2(2.5,5.0) );
   float sdcy2=sdCylinderXZ( p-vec3(2.5,17.0,-6.0), vec2(2.5,5.0) );
   
   res =opU3(res, vec3(sdcy1,1.0,MATERIAL_NO));
   res =opU3(res, vec3(sdcy2,1.0,MATERIAL_NO));
   return res;    
}   



///------------------------------------
vec3 GetDist(vec3 p  ) 
{	vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 pp=p;
	float planeDist1 = p.y+0.0;  //piso inf
    //res =opU3(res, vec3(planeDist1,-1.0,7.0)); //inf
    res =opU3(res, vec3(planeDist1,100.0,-1.0)); //inf

   p.y=p.y-5.0;
   
   vec3 p0=p;vec3 p1=p;vec3 p2=p;
   
   p0.z= opRep1D(p1.z, 30.0 );
   p1.z= opRep1D(p1.z, 76.0 );
   p2.z= opRep1D(p2.z, 50.0 );
   
   vec3 cci= ColumnaCaidaI(p1-vec3(-20.0,0.0,-5.0));
   res =opU3(res, cci);
   
   vec3 ccii= ColumnaCaidaII( p2-vec3(15.0,0.0,10.0));
   res =opU3(res, ccii);
   
   
   float le=6.0;
   float r1=4.5;
   float r2=0.5;
   float sdl1= sdLink( p0-vec3(0.0,1.0,0.0),  le,  r1,  r2 );
   res =opU3(res, vec3(sdl1,1.0,MATERIAL_NO));
   
   
   
   float le2=15.0;
   float r12=25.0;
   float r22=2.5;
   float sdl2= sdLink( p0-vec3(0.0,1.0,0.0),  le2,  r12,  r22 );
   res =opU3(res, vec3(sdl2,1.0,MATERIAL_NO));
    
    //res =opU3(res, vec3(1.0,0.0,MATERIAL_NO)); 
    //return (dist, id_color, id_material)
    return res;
}

//------------------------------------------------
vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

float RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   float t = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    
    #define DISTANCE_BIAS 0.75
    float minDist = 9999.0; 
    
    for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*t;
        dS = GetDist(p);
        t += dS.x;
        if ( abs(dS.x)<MIN_DIST  || i == PMaxSteps)
            {mObj.hitbln = true; minDist = abs(t); break;}
        if(t>MAX_DIST)
            {mObj.hitbln = false;    minDist = t;    break; } 
        marchCount++;
    }
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return t;
}

///-----------------------------
//Creado por dr2 en 2020-07-28
//https://www.shadertoy.com/view/3lfBz8
mat3 StdVuMat (float el, float az)
{ vec2 ori, ca, sa;
  ori = vec2 (el, az);
  ca = cos (ori);  sa = sin (ori);
  return mat3 (ca.y, 0., - sa.y, 0., 1., 0., sa.y, 0., ca.y) *
         mat3 (1., 0., 0., 0., ca.x, - sa.x, 0., sa.x, ca.x);
}
//Creado por dr2 en 2020-07-28
//https://www.shadertoy.com/view/3lfBz8
vec3 getMouse(vec3 ro)
{   vec4 mPtr = iMouse;
    mPtr.xy = mPtr.xy / iResolution.xy - 0.5;
     float tCur = iTime;
     float az = 0.;
     float el = -0.15 * PI;
    az += 2. * PI * mPtr.x;
    el += PI * mPtr.y;
     mat3 vuMat = StdVuMat (el, az);
	return ro*vuMat;
}
//---------------------------------------------------
float GetShadow(vec3 p, vec3 plig)
{   vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l , MAX_STEPS/2);
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}
//----------------------------------------------------
vec3 amb(vec3 c, float k)
{  return c * k; }

float diff(vec3 p,vec3 lp,vec3 n )
{   vec3 l = normalize(lp - p);
    float dif = clamp(dot(l, n), 0.0, 1.0);
    return dif;
}
float spec( vec3 p, vec3 lp,vec3 rd,vec3 n )
{ vec3 l = normalize(lp - p);
  vec3 r = reflect(-l, n);
  float spe =pow(clamp(dot(r, -rd), 0.0, 1.0), 20.0);
  return spe;
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 col) 
{   vec3 l = lp - p;
    vec3 ldir = normalize(p-rd);
    
    float distA = max(length(l), 0.01);
    float distB = 1.0/(length(p-lp));
    float dist=(distA+distB)/2.0;
    float atten = min(1./(1. + dist*0.5), 0.2);
    l /= (dist);
    
    vec3 n = normal;
   	vec3 r = reflect(-l, n);
    
    vec3 amb=amb(col, 0.5);
    float dif = diff( p, lp, n );
    float diff=max(dot(normalize(p-lp), -n), 0.0);;
    vec3 ln=normalize(lp);
    
    float spe= spec(  p,  lp, rd, n );
    float fre = pow(clamp(1.0 + dot(n, rd), 0.0, 1.0), 2.0);
    float dom = smoothstep(-1.0, 1.0, r.y);
     float bac=clamp(dot(n,-l),0.0,1.0);
    float rim=pow(1.0+dot(n,rd),3.0);
    float dn=.15*max(0.,dot(normalize(rd),-n));
    
     vec3  hal = normalize(-rd+l);
     float dif3 = clamp( dot(n,l), 0.0, 1.0 );
     float amb2 = clamp( 0.5 + 0.5*dot(n,vec3(0.0,1.0,0.0)), 0.0, 1.0 );
     float occ = 0.5 + 0.5*n.y;
    
    float fshadow;
    float sh = clamp(dot(n,normalize(lp)),0.0,1.0);
    
    if (mObj.blnShadow==true)
        {fshadow=GetShadow(p,lp);}
    else
        {fshadow=0.5;}

    vec3 lin=vec3(1.0);
    lin*= amb*amb2*occ;
    lin += 1.0*(dif+diff+dif3)*sh;
    lin += 2.5*spe*vec3(1.0);
    lin += 2.5*fre*vec3(1.);
    lin += 0.5*dom*vec3(1.);
    lin += 0.35*bac*vec3(1.);
    lin += 0.35*rim*vec3(1.);
    lin += 0.35*rim*dn*vec3(1.);
    lin += 0.4*pow(clamp(dot(hal,n),0.0,1.0),12.0)*dif3;
    lin *= atten*0.5*col*fshadow;
    lin *= vec3(1.0)*  max(normalize(vec3(length(lin))).z, 0.)+ .75; 
    lin = pow(lin,vec3(0.4545));
    return lin;
}
//----------------------------------------------------
vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    { vec3 col=tex3D(texture0, p/32., nor); return col; }
	if (i==101 ) { return tex3D(texture1, p/32., nor); }
	if (i==102 ) { return tex3D(texture2, p/32., nor); }
	if (i==103 ) { return tex3D(texture3, p/32., nor); }
}
//-------------------------------
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{  float intensity=1.0;
     vec3 result;
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj);
    return result;
}
///-------------------------------------
vec3 getSkyColA(vec3 rd) 
{ float t = (rd.x + 1.0) / 2.0;
    return vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}

//https://www.shadertoy.com/view/4lcSRn   ///IQ
vec3 pattern( in vec2 uv )
{   vec3 col = vec3(0.4);
    col += 0.4*smoothstep(-0.01,0.02,cos(uv.x*0.5)*cos(uv.y*0.5)); 
    col *= smoothstep(-1.0,-0.98,cos(uv.x))*smoothstep(-1.0,-0.98,cos(uv.y));
    return col;
}

vec3 SmoothXOR( vec2 puv )
{
    //vec2 p = 256.0 * fragCoord.xy/iResolution.x + iTime;
    vec2 p=10.0*puv;
    float an = smoothstep( -0.5, 0.5, cos(3.14159*iTime) );
    float x = 0.0;
    for( int i=0; i<7; i++ ) 
    {   vec2 a = floor(p);
        vec2 b = fract(p);
        x += mod( a.x + a.y, 2.0 ) * 
            // the following line implements the smooth xor
         mix( 1.0, 1.5*pow(4.0*(1.0-b.x)*b.x*(1.0-b.y)*b.y,0.25), an );
        p /= 2.0;
        x /= 2.0;
    }
    
    return  vec3( x, x, x);
}

//------------------------------------------------
vec3 getMaterial( vec3 pp, float id_material)
{ vec3 col=vec3(1.0);
  vec3 p=pp;
  vec3 l1;
    if (id_material==7.0)
    {return pattern( p.xz );}
    
    if (id_material==8.0)
    {return pattern( p.xy );}
    
    if (id_material==9.0)
    {return pattern( p.zy );}
    
    if (id_material==10.0)
    {return  SmoothXOR(p.xz );}
    
}

//-------------------------------------------------
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj; 
    
    if( mObj.hitbln==false) return  render_sky_color(rd);
    
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }
    
    if ( float( id_color)>=100.0  && float( id_color)<=199.0 ) 
 	{  vec3 coltex=getColorTextura(p, n, int( id_color));
        colobj=coltex;
	}

    if (id_material>-1.0 && id_color==-1)
        { 
            colobj=vec3(0.5);
            colobj*=getMaterial(p, id_material); 
            return colobj;
        }
    return colobj;
}


vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
   TObj Obj;
   mObj.rd=rd;
   mObj.ro=ro;
   vec3 p;

   float d=RayMarch(ro,rd, MAX_STEPS);
   
    Obj=mObj;
    if(mObj.hitbln) 
    {   p = (ro + rd * d );  
        vec3 nor=mObj.normal;
        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1);
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2);
        
        col *= 1.0 - pow(d /(MAX_DIST) , 3.5);  
        col= result;
    }
    else if(d>MAX_DIST)
    col= render_sky_color(rd);
    
   return col;
}

///---------------------------------------------
vec3 linear2srgb(vec3 c) {
    return mix(
        12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055,
        step(vec3(0.0031308), c));
}

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{    return vec3(1.0) - exp(-hdrColor * exposure);  }

///---------------------------------------------
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*5.0,360.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	light_pos1= vec3(5.0, 10.0, -10.0 ); light_color1=vec3( 1.0 );
 	light_pos2= vec3( -10.0, 20.0, -10.0 ); light_color2 =vec3( 1.0 ); 
 
   vec3 ro=vec3(0.0,7.0,-25.0+t);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
   
   
    light_pos1+=ro;
    light_pos2+=ro;
    vec3 col= Render( ro,  rd);
    col = linear2srgb(col);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

